////////////////////////////////////////////////////////////////
//
// Author	:	Michael Celey (MC)
//
// File		:	CPlayer.h
//
// Purpose	:	Contains all functionality for the player object
//				in the game.  This class is a singleton.
//
////////////////////////////////////////////////////////////////

#pragma once

#include "CBase.h"
#include <vector>
#include "AnimInstance.h"
using std::vector;

class CEvent;

class CPlayer : public CBase
{
public:
	

private:
	CAnimInstance* m_pCurrentAnimation;

	float m_nOffsetX;
	float m_nOffsetY;

	//the current line the player is on
	int m_nLine;

	//Boolean to determine if dead
	bool m_bIsDead;

	//Name the player enters
	string m_szName;

	//Time elapsed since last shot
	float m_fLastShotTime;

	// Proper Singleton Privates
	CPlayer();
	CPlayer(const CPlayer&);
	CPlayer& operator=(const CPlayer&);
	~CPlayer();

public:
	//////////////////////////////////////////////////
	//	Function:	GetInstance
	//  Last Modified: August 8, 2008
	//	Purpose:	Returns the single instance of this
	//				class.
	//////////////////////////////////////////////////
	static CPlayer* GetInstance()
	{
		static CPlayer instance;
		return &instance;
	}

	//////////////////////////////////////////////////
	//	Function:	Input
	//  Last Modified: July 25, 2008
	//	Purpose:	Updates the player's position based 
	//  on several possible factors	including velocity,
	//  time, input, and position.
	//////////////////////////////////////////////////
	bool Input();

	//////////////////////////////////////////////////
	//	Function:	Update
	//  Last Modified: July 25, 2008
	//	Purpose:	Updates the player's position based 
	//  on several possible factors	including velocity,
	//  time, input, and position.
	//////////////////////////////////////////////////
	void Update(float fElapsedTime);


	//////////////////////////////////////////////////
	//	Function:	Render
	//	Last Modified: July 25, 2008
	//	Purpose:	Draws the player to the screen
	//////////////////////////////////////////////////
	void Render();


	/////////////////////////////////
	//	Function:	HandleEvent
	//  Last Modified: July 25, 2008
	//	Purpose: handles an event
	/////////////////////////////////
	void HandleEvent(CEvent* pEvent);


	// Accessors
	CAnimInstance* GetCurrAnimation()const { return m_pCurrentAnimation; }
	float GetOffsetX()const {return m_nOffsetX;}
	float GetOffsetY()const {return m_nOffsetY;}
	bool IsDead() const {return m_bIsDead;}
	string GetName() const {return m_szName;}

	// Mutators
	void SetDead(bool bDead) {m_bIsDead = bDead;}
	void SetCurrAnimation(CAnimInstance* pCurrAni) { m_pCurrentAnimation = pCurrAni; }
	void SetOffsetX(float fOffset) {m_nOffsetX = fOffset;}
	void SetOffsetY(float fOffseet) {m_nOffsetY = fOffseet;}
	void SetName(string szName) {m_szName = szName;}


};